/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.constask;

import com.ibm.hwmca.base.constask.ConsoleTaskConstants;
import com.ibm.hwmca.base.constask.ConsoleTaskData;
import com.ibm.hwmca.base.constask.ConsoleTasksErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class ConsoleTasks
implements Serializable,
ConsoleTasksErrorIds,
ConsoleTaskConstants {
    private static ArrayList tasks;
    private ConsoleTaskData taskData;
    public static final String CONSOLE_TASKS_PERFORMED_DATA_FILE = "actzuict.dat";
    public static final String CONSOLE_TASKS_PERFORMED_ORIG_DATA_FILE = "actzuict.org";
    boolean newFile;
    File consoleTasksFile;
    File consoleTasksFileBackUp;
    private String filePath;
    private String fullTaskFileName;
    private String fullBUTaskFileName;
    private static final int TASK_RECORD_COUNT = 100;
    private static final long MIN_TASK_ARRAY_SIZE = 101L;
    private static final char ARROW = '>';
    public static final String DOTS = ".........................";
    public int TASK_ENTRY_LENGTH;
    private static FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XDRYTSKT";
    private static final String TRACE_MASKF = "XDRYTSKF";
    private static final String TRACE_MASKD = "XDRYTSKD";

    public ConsoleTasks() {
        Trace.trace(TRACE_MASKT, "-> ConsoleTasks() Constructor 06/10/02 <-");
        this.TASK_ENTRY_LENGTH = 198;
    }

    public ConsoleTasks(ConsoleTaskData taskData) {
        Trace.trace(TRACE_MASKT, "-> ConsoleTasks(ConsoleTaskData) Constructor - 02/28/02 16:52");
        this.newFile = false;
        this.taskData = taskData;
        this.TASK_ENTRY_LENGTH = 28 + 18 + 150 + 2;
        StringBuffer taskString = this.buildTaskString();
        StringBuffer summaryString = this.buildSummaryString();
        this.newFile = this.openConsoleTasksPerformedFile();
        if (this.newFile) {
            this.initializeTaskArray(taskString, summaryString);
        } else {
            this.readTaskDataFile(true);
            this.updateConsoleTasks(taskString);
            this.updateTasksSummary(summaryString);
        }
        this.openConsoleTasksPerformedFile();
        this.writeConsoleTasksPerformedDataFile();
        Trace.trace(TRACE_MASKT, "<- ConsoleTasks(ConsoleTaskData) Constructor ");
    }

    private boolean openConsoleTasksPerformedFile() {
        long fileLength = 0L;
        boolean createNewFile = false;
        Trace.trace(TRACE_MASKT, "->openConsoleTasksPerformedFile ");
        try {
            this.filePath = BaseFileControl.getFilePath(CONSOLE_TASKS_PERFORMED_DATA_FILE);
            Trace.trace(TRACE_MASKD, "filePath for CONSOLE_TASKS_PERFORMED_DATA_FILE= " + this.filePath);
        }
        catch (HException he) {
            Trace.trace(TRACE_MASKF, "Error getting path to our file: " + he);
        }
        boolean created = false;
        this.fullTaskFileName = this.filePath + CONSOLE_TASKS_PERFORMED_DATA_FILE;
        Trace.trace(TRACE_MASKD, "fullTaskFileName for CONSOLE_TASKS_PERFORMED_DATA_FILE= " + this.fullTaskFileName);
        this.consoleTasksFile = new File(this.fullTaskFileName);
        Trace.trace(TRACE_MASKD, "created consoleTasksFile object");
        if (this.consoleTasksFile.exists() && this.consoleTasksFile.isFile() && !this.consoleTasksFile.isDirectory() && this.consoleTasksFile.length() > 0L) {
            Trace.trace(TRACE_MASKD, "consoleTasksFile exists & is a file");
            createNewFile = false;
            fileLength = this.consoleTasksFile.length();
            Trace.trace(TRACE_MASKD, "file length = " + fileLength);
            created = true;
        } else {
            Trace.trace(TRACE_MASKD, "consoleTasksFile DOES NOT exist must CREATE");
            createNewFile = true;
            try {
                created = this.consoleTasksFile.createNewFile();
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, "Error creating new Console Tasks file: " + ioexc.getMessage());
                new FrameworkLog(logInfo, 256, ioexc).log();
            }
            if (created) {
                Trace.trace(TRACE_MASKD, "Created new Console Tasks file ");
            }
        }
        Trace.trace(TRACE_MASKT, "<-openConsoleTasksPerformedFile createNewFile =  " + createNewFile);
        return createNewFile;
    }

    private void initializeTaskArray(StringBuffer taskBuffer, StringBuffer summaryBuffer) {
        Trace.trace(TRACE_MASKT, "->initializeTaskArray ");
        Long numEntries = new Long(101L);
        tasks = new ArrayList(numEntries.intValue());
        Trace.trace(TRACE_MASKD, "numEntries = " + numEntries);
        Trace.trace(TRACE_MASKD, "taskBuffer    (passed in)= " + taskBuffer);
        Trace.trace(TRACE_MASKD, "summaryBuffer (passed in)= " + summaryBuffer);
        String taskString = taskBuffer.toString();
        tasks.add(0, taskString);
        Trace.trace(TRACE_MASKD, "first tasks array entry = " + tasks.get(0));
        int i = 1;
        while (i < 100) {
            String taskPlaceHolder = new String(">.........................");
            tasks.add(i, taskPlaceHolder);
            Trace.trace(TRACE_MASKD, "added taskPlaceHolder to tasks array i = " + i);
            Trace.trace(TRACE_MASKD, "taskString[" + i + "] = " + tasks.get(i));
            ++i;
        }
        Trace.trace(TRACE_MASKD, "add summary string to tasks array i = " + i);
        String summaryString = summaryBuffer.toString();
        tasks.add(i, summaryString);
        Trace.trace(TRACE_MASKD, "Summary taskString[" + i + "] = " + tasks.get(i));
        Trace.trace(TRACE_MASKT, "<-initializeTaskArray ");
    }

    private void readTaskDataFile(boolean BACKUP) {
        long fileLength = 0L;
        boolean created = false;
        Trace.trace(TRACE_MASKD, "->readTaskDataFile - backup =  " + BACKUP);
        if (BACKUP) {
            this.fullBUTaskFileName = this.filePath + CONSOLE_TASKS_PERFORMED_ORIG_DATA_FILE;
            Trace.trace(TRACE_MASKD, "fullBUTaskFileName for CONSOLE_TASKS_PERFORMED_ORIG_DATA_FILE= " + this.fullBUTaskFileName);
            this.consoleTasksFileBackUp = new File(this.fullBUTaskFileName);
            try {
                created = this.consoleTasksFileBackUp.createNewFile();
                if (created) {
                    Trace.trace(TRACE_MASKD, "Created Console Tasks Backup file");
                } else {
                    Trace.trace(TRACE_MASKD, "Console Tasks Backup file NOT CREATED");
                }
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, "Error creating Console Tasks Backup file: " + ioexc.getMessage());
                new FrameworkLog(logInfo, 257, ioexc).log();
            }
        }
        fileLength = this.consoleTasksFile.length();
        Trace.trace(TRACE_MASKD, "consoleTasksFile length = " + fileLength);
        BufferedReader in = null;
        BufferedWriter out = null;
        String line = null;
        Long numEntries = new Long(fileLength / (long)this.TASK_ENTRY_LENGTH);
        Trace.trace(TRACE_MASKD, "Initial # of entries in task ArrayList= " + numEntries);
        if (numEntries.compareTo(new Long(101L)) < 0) {
            numEntries = new Long(101L);
        }
        Trace.trace(TRACE_MASKD, "Adjusted # of entries in task ArrayList= " + numEntries);
        tasks = new ArrayList(numEntries.intValue());
        try {
            in = new BufferedReader(new FileReader(this.fullTaskFileName));
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, "Error creating new BufferedReader for Console Tasks file: " + ioexc.getMessage());
            new FrameworkLog(logInfo, 258, ioexc).log();
        }
        if (BACKUP) {
            try {
                out = new BufferedWriter(new FileWriter(this.fullBUTaskFileName));
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, "Error creating new BufferedWriter for Console Tasks bu file: " + ioexc.getMessage());
                new FrameworkLog(logInfo, 259, ioexc).log();
            }
        }
        if (!(in == null || out == null && BACKUP)) {
            do {
                try {
                    line = in.readLine();
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, "Error reading line from file: " + ioexc.getMessage());
                    new FrameworkLog(logInfo, 260, ioexc).log();
                }
                if (line == null) continue;
                tasks.add(line);
                Trace.trace(TRACE_MASKD, "found file entry [" + line + "].added to array");
                if (!BACKUP) continue;
                try {
                    out.write(line);
                    out.newLine();
                    Trace.trace(TRACE_MASKD, "found file entry [" + line + "].added to backup file");
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKD, "Error writing task backupactzuict.org" + ioexc.getMessage());
                    new FrameworkLog(logInfo, 261, ioexc).log();
                }
            } while (line != null);
            Trace.trace(TRACE_MASKD, "size of task array is [" + tasks.size() + "].");
        }
        if (out != null && BACKUP) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (BACKUP) {
            this.consoleTasksFile.delete();
            Trace.trace(TRACE_MASKD, "deleted consoleTasksFile");
        }
        Trace.trace(TRACE_MASKD, "<-readTaskDataFile ");
    }

    private void updateConsoleTasks(StringBuffer taskBuffer) {
        StringBuffer sb = new StringBuffer();
        Trace.trace(TRACE_MASKD, "->updateConsoleTasks ");
        sb.ensureCapacity(this.TASK_ENTRY_LENGTH + 1);
        Trace.trace(TRACE_MASKD, "taskBuffer = " + taskBuffer);
        String taskString = taskBuffer.toString();
        Trace.trace(TRACE_MASKD, "taskString = " + taskString);
        int i = 0;
        while (i < 100) {
            String s = (String)tasks.get(i);
            if (s.charAt(0) == '>') {
                tasks.set(i, taskString);
                if (i == 99) {
                    s = (String)tasks.get(0);
                    sb.insert(0, s);
                    sb.setCharAt(0, '>');
                    s = sb.toString();
                    tasks.set(0, s);
                    Trace.trace(TRACE_MASKD, "reset entry [0] in tasks Array to " + s);
                    break;
                }
                int nextIndex = i + 1;
                s = (String)tasks.get(nextIndex);
                sb.insert(0, s);
                sb.setCharAt(0, '>');
                s = sb.toString();
                tasks.set(nextIndex, s);
                Trace.trace(TRACE_MASKD, "reset entry [" + nextIndex + "] in tasks Array to " + s);
                break;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "<-updateConsoleTasks ");
    }

    private StringBuffer buildTaskString() {
        String taskString = new String(DOTS);
        int stringLength = 0;
        int targetNameLength = 28;
        int dateTimeStampLength = 18;
        int taskNameLength = 150;
        Trace.trace(TRACE_MASKD, "->buildTaskString  ");
        int buffIndex = 0;
        StringBuffer taskBuff = new StringBuffer();
        taskBuff.ensureCapacity(this.TASK_ENTRY_LENGTH + 1);
        taskBuff.insert(buffIndex, DOTS);
        Trace.trace(TRACE_MASKD, "initialized taskBuff =" + taskBuff);
        Trace.trace(TRACE_MASKD, "taskBuff capacity = " + taskBuff.capacity());
        String workString = this.taskData.getTargetName();
        Trace.trace(TRACE_MASKD, "workString with targetName = " + workString);
        stringLength = workString.length();
        Trace.trace(TRACE_MASKD, "workString length = " + stringLength);
        if (stringLength <= targetNameLength - 2) {
            taskBuff.insert(1, workString);
        } else {
            taskBuff.insert(1, workString.substring(0, targetNameLength - 1));
        }
        Trace.trace(TRACE_MASKD, "taskBuff after adding targetName= " + taskBuff);
        buffIndex = targetNameLength + 1;
        Trace.trace(TRACE_MASKD, "buffIndex after adding targetName= " + buffIndex);
        taskBuff.append(this.taskData.getDateTime());
        Trace.trace(TRACE_MASKD, "taskBuff after adding date and time= " + taskBuff);
        Trace.trace(TRACE_MASKD, "buffIndex after adding date and time= " + (buffIndex += dateTimeStampLength));
        workString = this.taskData.getTaskName();
        Trace.trace(TRACE_MASKD, "workString with taskName = " + workString);
        stringLength = workString.length();
        Trace.trace(TRACE_MASKD, "workString length = " + stringLength);
        if (buffIndex + stringLength <= this.TASK_ENTRY_LENGTH) {
            taskBuff.append(workString);
        } else {
            taskBuff.append(workString.substring(0, this.TASK_ENTRY_LENGTH - buffIndex));
        }
        Trace.trace(TRACE_MASKD, "taskBuff after adding task name= " + taskBuff);
        Trace.trace(TRACE_MASKD, "<-buildTaskString  ");
        return taskBuff;
    }

    private StringBuffer buildSummaryString() {
        int buffIndex = 0;
        int stringLength = 0;
        Trace.trace(TRACE_MASKD, "->buildSummaryString  ");
        String countString = this.taskData.getCount();
        Trace.trace(TRACE_MASKD, "countString = " + countString);
        String dateTime = this.taskData.getDateTime();
        Trace.trace(TRACE_MASKD, "date/timeString = " + dateTime);
        String nameOfTaskString = this.taskData.getTaskName();
        Trace.trace(TRACE_MASKD, "nameofTaskString with task name= " + nameOfTaskString);
        stringLength = nameOfTaskString.length();
        Trace.trace(TRACE_MASKD, "nameofTaskString length= " + stringLength);
        if (stringLength >= 150) {
            nameOfTaskString = nameOfTaskString.substring(0, 150);
            stringLength = nameOfTaskString.length();
            Trace.trace(TRACE_MASKD, "nameofTaskString SUBSTRING= " + nameOfTaskString);
            Trace.trace(TRACE_MASKD, "new nameofTaskString length= " + stringLength);
        }
        StringBuffer sumBuff = new StringBuffer();
        sumBuff.ensureCapacity(this.TASK_ENTRY_LENGTH + 1);
        Trace.trace(TRACE_MASKD, "sumBuff capacity = " + sumBuff.capacity());
        sumBuff.insert(0, countString);
        int countLength = countString.length();
        int spaceCount = 6 - countLength;
        sumBuff.append(DOTS.substring(0, spaceCount));
        buffIndex = 6;
        Trace.trace(TRACE_MASKD, "sumBuff after adding count and spaces= " + sumBuff);
        Trace.trace(TRACE_MASKD, "buffIndex = " + buffIndex);
        sumBuff.append(dateTime);
        countLength = dateTime.length();
        spaceCount = 18 - countLength;
        sumBuff.append(DOTS.substring(0, spaceCount));
        Trace.trace(TRACE_MASKD, "sumBuff after adding date/time= " + sumBuff);
        Trace.trace(TRACE_MASKD, "buffIndex = " + (buffIndex += 18));
        countLength = nameOfTaskString.length();
        if (buffIndex + countLength <= this.TASK_ENTRY_LENGTH) {
            sumBuff.append(nameOfTaskString);
        } else {
            sumBuff.append(nameOfTaskString.substring(0, this.TASK_ENTRY_LENGTH - buffIndex));
        }
        Trace.trace(TRACE_MASKD, "sumBuff after adding task name= " + sumBuff);
        Trace.trace(TRACE_MASKD, "buffIndex = " + buffIndex);
        Trace.trace(TRACE_MASKD, "length of sumBuff = " + sumBuff.length());
        Trace.trace(TRACE_MASKD, "Summary Buffer= " + sumBuff);
        Trace.trace(TRACE_MASKD, "<-buildSummaryString  ");
        return sumBuff;
    }

    private void updateTasksSummary(StringBuffer summaryBuffer) {
        Trace.trace(TRACE_MASKD, "->updateTasksSummary ");
        Trace.trace(TRACE_MASKD, "new summaryBuffer = " + summaryBuffer);
        boolean found = false;
        int countLength = 6;
        int dateTimeStampLength = 18;
        String summaryString = summaryBuffer.toString();
        Trace.trace(TRACE_MASKD, "countLength = " + countLength);
        Trace.trace(TRACE_MASKD, "dateTimeStampLength =" + dateTimeStampLength);
        Trace.trace(TRACE_MASKD, "TASK_ENTRY_LENGTH=" + this.TASK_ENTRY_LENGTH);
        int targetIndex = summaryString.indexOf(91);
        String summarySubString = targetIndex > 0 ? summaryString.substring(countLength + dateTimeStampLength, targetIndex) : summaryString.substring(countLength + dateTimeStampLength);
        Trace.trace(TRACE_MASKD, "summarySubString = " + summarySubString);
        Trace.trace(TRACE_MASKD, "Loop through tasks array to find similar summary entry");
        Trace.trace(TRACE_MASKD, "size of tasks array = " + tasks.size());
        int i = 100;
        while (i < tasks.size() && !found) {
            Trace.trace(TRACE_MASKD, "index into tasks array = " + i);
            String s = (String)tasks.get(i);
            Trace.trace(TRACE_MASKD, "tasks array[" + i + "] = " + s);
            targetIndex = s.indexOf(91);
            String subString = targetIndex > 0 ? s.substring(countLength + dateTimeStampLength, targetIndex) : s.substring(countLength + dateTimeStampLength);
            Trace.trace(TRACE_MASKD, "tasks array[" + i + "] substring  = " + subString);
            int compare = subString.compareTo(summarySubString);
            if (compare == 0) {
                Trace.trace(TRACE_MASKD, "Found match for summaryString");
                found = true;
                targetIndex = s.indexOf(46);
                subString = targetIndex > 0 ? s.substring(0, targetIndex) : s.substring(0, countLength);
                Trace.trace(TRACE_MASKD, "string subString =" + subString);
                try {
                    int thisTaskCount = Integer.parseInt(subString);
                    Trace.trace(TRACE_MASKD, "taskCount =" + thisTaskCount);
                    Trace.trace(TRACE_MASKD, "updated taskCount =" + ++thisTaskCount);
                    subString = Integer.toString(thisTaskCount);
                    Trace.trace(TRACE_MASKD, "updated taskCount string version =" + subString);
                    StringBuffer sb = new StringBuffer(subString);
                    sb.ensureCapacity(this.TASK_ENTRY_LENGTH + 1);
                    int bufferLength = sb.length();
                    int dotCount = countLength - bufferLength;
                    sb.append(DOTS.substring(0, dotCount));
                    sb.append(summaryString.substring(countLength));
                    Trace.trace(TRACE_MASKD, "updated stringBuffer =" + sb);
                    s = sb.toString();
                    tasks.set(i, s);
                    Trace.trace(TRACE_MASKD, "updated task array entry = " + tasks.get(i));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (!found) {
            tasks.add(i, summaryString);
            Trace.trace(TRACE_MASKD, "no previous entry found - index = " + i);
            Trace.trace(TRACE_MASKD, "updated task array entry = " + tasks.get(i));
        }
        Trace.trace(TRACE_MASKD, "<-updateTasksSummary ");
    }

    private void writeConsoleTasksPerformedDataFile() {
        long fileLength = 0L;
        BufferedWriter out = null;
        String line = null;
        Trace.trace(TRACE_MASKD, "->writeConsoleTasksPerformedDataFile");
        try {
            out = new BufferedWriter(new FileWriter(this.fullTaskFileName));
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, "Error creating new BufferedWriter for new updated Console Tasks file: " + ioexc);
            new FrameworkLog(logInfo, 263, ioexc).log();
        }
        Trace.trace(TRACE_MASKD, "size of tasks arraylist = " + tasks.size());
        int i = 0;
        while (i < tasks.size()) {
            line = (String)tasks.get(i);
            if (line != null) {
                Trace.trace(TRACE_MASKD, "line read from arraylist[" + i + "]= " + line);
                try {
                    out.write(line);
                    out.newLine();
                    Trace.trace(TRACE_MASKD, "found file entry [" + i + "] [" + line + "].wrote to new file");
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, "Error writing update file" + this.fullTaskFileName + ioexc.getMessage());
                    new FrameworkLog(logInfo, 264, ioexc).log();
                }
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "size of new file [" + this.consoleTasksFile.length() + "].");
        Trace.trace(TRACE_MASKD, "size of new file [" + this.fullTaskFileName.length() + "].");
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioeexc) {
                // empty catch block
            }
        }
        if (!this.newFile && this.consoleTasksFileBackUp.exists() && this.consoleTasksFileBackUp.isFile() && !this.consoleTasksFileBackUp.isDirectory()) {
            this.consoleTasksFileBackUp.delete();
        }
        Trace.trace(TRACE_MASKD, "<-writeConsoleTasksPerformedDataFile");
    }

    public static synchronized void updateTasksPerformed(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "ConsoleTasks synch static updateTasksPerformed method <-->");
        if (parms != null) {
            ConsoleTaskData consoleTaskData = new ConsoleTaskData(parms);
            ConsoleTasks consoleTasks = new ConsoleTasks(consoleTaskData);
        }
    }

    public static synchronized ArrayList getConsoleTasksFileData() {
        Trace.trace(TRACE_MASKT, "-> ConsoleTasks synch static getConsoleTasksFileData method ");
        ConsoleTasks ct = new ConsoleTasks();
        boolean fileNotThere = ct.openConsoleTasksPerformedFile();
        if (!fileNotThere) {
            ct.readTaskDataFile(false);
        }
        return tasks;
    }

    static {
        logInfo = new FrameworkClassLogInfo(85, "ConsoleTasks");
    }
}

